/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.message;

import filenet.vw.api.VWValidationError;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.message.VWValidationToolTip;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class VWValidationMessageTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public VWValidationMessageTableCellRenderer() {
        try {
            this.setOpaque(true);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String msg = null;
        String errorString = null;
        VWValidationError error = null;
        if (value instanceof VWValidationError) {
            error = (VWValidationError)value;
        } else if (value instanceof String) {
            errorString = value.toString();
        }
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
        }
        this.setFont(table.getFont());
        if (error != null) {
            msg = error.getMessage();
        } else if (errorString != null) {
            msg = errorString;
        }
        this.setText(msg);
        this.setToolTipText(error != null ? VWValidationToolTip.createValidationToolTip(error) : VWStringUtils.formatToolTip(msg, 0));
        return this;
    }
}

